/*
 * Decompiled with CFR 0.152.
 */
package com.hyjy.lib;

import java.io.UnsupportedEncodingException;

public class H_URLDecoder {
    public static String decode(String s) {
        String str = null;
        try {
            str = H_URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String decode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuffer sb = new StringBuffer(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        if (enc.length() == 0) {
            throw new UnsupportedEncodingException("URLDecoder: empty string enc parameter");
        }
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(H_URLDecoder.byteToString(bytes, 0, pos));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    static String byteToString(byte[] bSou, int iStartId, int iEndId) {
        StringBuffer str = new StringBuffer();
        if (iStartId >= 0 && iStartId <= iEndId) {
            int[] Text = new int[iEndId - iStartId];
            for (int i = iStartId; i < iEndId; ++i) {
                Text[i - iStartId] = bSou[i] < 0 ? bSou[i] ^ 0xFFFFFF00 : bSou[i];
            }
            int iTextLength = Text.length;
            for (int i = 0; i < iTextLength; ++i) {
                int tem = 0;
                if (Text[i] == 0) {
                    tem = 0;
                } else if (Text[i] >> 7 == 0) {
                    tem = Text[i];
                } else if ((Text[i] == 0 || Text[i] >> 5 == 6) && i + 1 < iTextLength) {
                    tem = (Text[i] & 0x3F) << 6 | Text[++i] & 0x3F;
                } else if (Text[i] >> 4 == 14 && i + 2 < iTextLength) {
                    int n = (Text[i] & 0xF) << 12;
                    i = i + 1;
                    tem = n | (Text[i] & 0x3F) << 6 | Text[++i] & 0x3F;
                }
                str.append(String.valueOf(tem));
            }
        }
        return str.toString();
    }
}

