/*
 * Decompiled with CFR 0.152.
 */
package com.rovio.rtool.mobile.ui;

import com.rovio.rtool.mobile.Resources;
import com.rovio.rtool.mobile.ui.ContentItem;
import com.rovio.rtool.mobile.ui.MenuItem;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class InputBox
extends MenuItem {
    private static final int INPUTBOX_COLOR_CARET = 238;
    private static final int INPUTBOX_COLOR_TEXT = 0;
    private static final int INPUTBOX_COLOR_HIGHLIGHT_BORDER = 0xCCCCCC;
    private static final int INPUTBOX_COLOR_BORDER = 0x808080;
    private static final int INPUTBOX_COLOR_BACKGROUND = 0xFFFFEE;
    short actionId;
    short pageLinkId;
    static int sm_caretBlinkTime = 0;
    private static final int CARET_BLINK_MILLIS = 1000;
    static int sm_caretCounter = 0;
    private static boolean sm_capsMode;
    int m_itemWidth;
    int m_itemHeight;
    Font m_textFont = ContentItem.FONT_SMALL;
    StringBuffer m_text;
    boolean m_repeatingChangesText = false;
    int m_firstVisibleChar = 0;
    int m_caretPosition = 0;
    int m_minChars;
    int m_maxChars;

    public InputBox(int n, int n2, int n3) {
        this.m_itemWidth = n;
        this.m_itemHeight = this.m_textFont.getHeight() + 6;
        this.m_text = new StringBuffer(n3);
        this.m_minChars = n2;
        this.m_maxChars = n3;
    }

    public void addChar(char c) {
        this.m_repeatingChangesText = false;
        if (this.m_caretPosition < 0) {
            return;
        }
        if (this.m_text.length() < this.m_maxChars || this.m_maxChars == -1) {
            this.m_text.insert(this.m_caretPosition, c);
            ++this.m_caretPosition;
            this.m_repeatingChangesText = true;
        }
    }

    public void setChar(char c) {
        if (this.m_caretPosition < 0 || this.m_caretPosition > this.m_maxChars && this.m_maxChars != -1) {
            return;
        }
        if (this.m_repeatingChangesText) {
            this.m_text.setCharAt(this.m_caretPosition - 1, c);
        }
    }

    public boolean delChar() {
        this.m_repeatingChangesText = false;
        if (this.m_caretPosition <= 0) {
            return false;
        }
        --this.m_caretPosition;
        this.m_text.deleteCharAt(this.m_caretPosition);
        if (this.m_caretPosition < this.m_firstVisibleChar) {
            this.m_firstVisibleChar = this.m_caretPosition;
        }
        return true;
    }

    public void setText(String string) {
        this.m_text = new StringBuffer(string);
        this.m_caretPosition = this.m_text.length();
    }

    public boolean canFireAction() {
        return this.m_text.length() >= this.m_minChars;
    }

    public void mainLoopIteration(int n) {
        if ((sm_caretBlinkTime += n) > 1000) {
            ++sm_caretCounter;
            sm_caretBlinkTime -= 1000;
        }
    }

    public void typingInput(int n, int n2, char c) {
        if (sm_capsMode) {
            c = Character.toUpperCase(c);
        }
        switch (n) {
            case 100: {
                this.addChar(c);
                break;
            }
            case 101: {
                this.setChar(c);
                break;
            }
            case 103: {
                sm_capsMode = !sm_capsMode;
                this.m_repeatingChangesText = false;
                break;
            }
            case 102: {
                this.delChar();
                this.addChar(c);
            }
        }
        this.page.setCorrectSoftkeyLabels();
    }

    public void focusChange(boolean bl) {
        if (bl) {
            int n = this.m_text.length();
            if (n < this.m_minChars) {
                this.page.setSoftkeyLabel(null, 0);
            }
            if (n > 0) {
                this.page.setSoftkeyLabel(Resources.getText(-1), 1);
            }
            this.page.setInputMode(3);
        } else {
            this.page.setCorrectSoftkeyLabels();
            this.page.setInputMode(2);
        }
    }

    public void draw(Graphics graphics, int n, int n2, boolean bl) {
        graphics.setColor(0xFFFFEE);
        graphics.fillRect(n + 2, n2 + 2, this.m_itemWidth - 4, this.m_itemHeight - 4);
        graphics.setColor(0x808080);
        graphics.drawRect(n + 1, n2 + 1, this.m_itemWidth - 3, this.m_itemHeight - 3);
        graphics.setColor(0xCCCCCC);
        graphics.drawRect(n, n2, this.m_itemWidth - 1, this.m_itemHeight - 1);
        graphics.setColor(0);
        int n3 = n + 2;
        char[] cArray = null;
        if (this.m_text.length() > 0) {
            cArray = new char[this.m_text.length()];
            this.m_text.getChars(0, this.m_text.length(), cArray, 0);
            if (this.m_caretPosition < this.m_firstVisibleChar) {
                this.m_firstVisibleChar = this.m_caretPosition;
            }
            n3 = this.m_textFont.charsWidth(cArray, this.m_firstVisibleChar, this.m_caretPosition - this.m_firstVisibleChar);
            while (n3 > this.m_itemWidth - 6) {
                ++this.m_firstVisibleChar;
                n3 = this.m_textFont.charsWidth(cArray, this.m_firstVisibleChar, this.m_caretPosition - this.m_firstVisibleChar);
            }
            n3 += n + 2;
            graphics.setFont(this.m_textFont);
            graphics.clipRect(n + 2, n2, this.m_itemWidth - 6, this.m_itemHeight);
            graphics.drawChars(cArray, this.m_firstVisibleChar, cArray.length - this.m_firstVisibleChar, n + 3, n2 + 3, 20);
        }
        if (bl) {
            graphics.setColor(238);
            graphics.drawLine(n3, (n2 += 2) + 1, n3, n2 + this.m_textFont.getHeight());
        }
    }
}

